data {
  int<lower=0> N;
  vector[N] y;
}
parameters {
  real alpha;
  vector[2] beta;
  real<lower=0> sigma;
}
model {
    y[1] ~ normal(alpha, sigma);
    y[2] ~ normal(alpha + beta[1]*y[1], sigma);
  for (n in 3:N) {
    y[n] ~ normal(alpha + beta[1]*y[n-1] + beta[2]*y[n-2], sigma);
  }
}
generated quantities{
}
